class Arrow extends Container {
	constructor (arrowLength, fillColour, outlineColour, outlineThickness, direction, arrowProportion){

		super();

		if (arrowLength == null){
			this.arrowLength = 100;
		} else {
			this.arrowLength = arrowLength;
		}

		if (fillColour == null){
			this.fillColour = black;
		} else {
			this.fillColour = fillColour;
		}

		if (outlineColour == null){
			this.outlineColour = black;
		} else {
			this.outlineColour = outlineColour;
		}

		if (outlineThickness == null){
			this.outlineThickness = 2;
		} else {
			this.outlineThickness = outlineThickness;
		}

		if (direction == null){
			this.direction = "right";
		} else {
			this.direction = direction;
		}

		if (arrowProportion == null){
			this.arrowProportion = 0.3;
		} else {
			this.arrowProportion = arrowProportion;
		}

		var triangleSide = this.arrowProportion*this.arrowLength;
		var triangleLength = Math.sqrt(3)/2*triangleSide;
		var segmentLength = this.arrowLength - triangleLength;

		this.segment = new Shape().addTo(this);
		

		if (this.direction == "right"){
			this.segment.graphics.ss(this.outlineThickness).s(this.outlineColour).f(this.fillColour).mt(0, 0).lt(segmentLength, 0);
			this.triangle = new Triangle(triangleSide, triangleSide, triangleSide, this.fillColour, this.outlineColour).addTo(this).loc(this.arrowLength - 2/3*triangleLength, 0).rot(90);
		} else if (this.direction == "left"){
			this.segment.graphics.ss(this.outlineThickness).s(this.outlineColour).f(this.fillColour).mt(this.arrowLength - segmentLength, 0).lt(this.arrowLength, 0);
			this.triangle = new Triangle(triangleSide, triangleSide, triangleSide, this.fillColour, this.outlineColour).addTo(this).loc(2/3*triangleLength, 0).rot(-90);
		}

		return this;
	}
}