class FractionArray extends FractionRepresentation {// use JS6 extends keyword
	constructor (whole, numerator, denominator, drawWidth, drawHeight, customParms) {

		super(whole, numerator, denominator, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		//zog("Creating a FractionArray - numerator="+this.numerator+" denominator="+this.denominator);
		this.fractionValue = this.decimalValueOf();

		//fillOrder determines the order in which the cells in the partial whole are shaded.
		if (!customParms || !customParms.fillOrder){
			this.fillOrder = "first";
		} else if (customParms.fillOrder == "first" || customParms.fillOrder == "last" || customParms.fillOrder == "random") {//3 valid options
			this.fillOrder = customParms.fillOrder;
		} else{
			zog("WARNING - Invalid option, fillOrder has been set to first");
			this.fillOrder = "first";
		}

		this.partsArray = new Array();
		this.factorArray = new Array();
		this.fillColourArray = new Array();
		this.partWidthArray = new Array();
		this.availableWidth = 0.9*drawWidth;
		this.availableHeight = 0.9*drawHeight;
		this.horMargin =0.05*drawWidth;
		this.vertMargin = 0.05*drawHeight;

		if (customParms.forceFillColour == null){
			this.forceFillColour = false;
		} else {
			this.forceFillColour = true;
			this.customFillColour = customParms.forceFillColour;
			this.fillColourArray = customParms.fillColourArray;
		}

		this.numWholes = Math.ceil(this.fractionValue);
		if (this.fractionValue == 0){
			this.numWholes =1;
		}
		this.numFullWholes = this.numWholes - 1;

		if (customParms.arrayDimensions){
			this.arrayDimensions = customParms.arrayDimensions;
		} else {
			this.arrayDimensions = this.determineArrayDimensions();
		}

		if (this.fractionValue >1){
			//assuming the cards are squares or the width will be greater than the height ,more rows is preferable
			this.numRows = Math.max(this.arrayDimensions[0], this.arrayDimensions[1]);//want more rows than columns since they will fit better
			this.numColumnsPerWhole = Math.min(this.arrayDimensions[0],this.arrayDimensions[1]);
			this.numColumns = this.numWholes*this.numColumnsPerWhole + this.numFullWholes;//extras are for the space between wholes

			this.spaceBetweenWholesWidth = this.availableWidth*0.05;
			//adjust available width to account for space between wholes
			this.availableWidth = this.availableWidth - this.spaceBetweenWholesWidth *(this.numFullWholes);
			this.partitionWidth = this.availableWidth/(this.numWholes * this.numColumnsPerWhole);
			this.partitionHeight = this.availableHeight/this.numRows;

		} else {

			this.numRows = this.arrayDimensions[0];
			this.numColumns = this.arrayDimensions[1];
			this.numColumnsPerWhole = this.numColumns;
			this.spaceBetweenWholesWidth = 0;;
			this.partitionWidth = this.availableWidth/this.numColumns;
			this.partitionHeight = this.availableHeight/this.numRows;
		}
		this.loopCounter = 0;
		this.createArray();

		//setting line thicknesses to be used for dashes and wholeBorder
		this.roundedHeight = Math.floor(this.drawHeight*0.25);
		this.borderWeight = Math.floor(this.roundedHeight/10);
		this.dashWeight = Math.max(1, Math.ceil(this.borderWeight/4));

		this.createPartitions();
		this.createWholeBorders();
	}

	determineArrayDimensions(){
		for (var j=1; j<=this.denominator; j++){
			if (this.denominator%j == 0){
				this.factorArray.push(j);
			}
		}
		var numRows = this.factorArray[Math.floor(Math.random()*this.factorArray.length)];
		var numColumns = this.denominator/numRows;
		return [numRows, numColumns];
	}

	createArray(){
		this.loopCounter++;//counting the number of attempts it takes to make the array
		var numShadedParts = this.whole * this.denominator + this.numerator;
		var numUnShadedParts = this.numWholes*this.denominator - numShadedParts;
		var numShadedPartsInLastWhole = this.denominator - numUnShadedParts;
		var success = true;
		var myPart;

		if((numUnShadedParts == 0 || numShadedParts == 0 || this.denominator == 2) && this.fillOrder == "random"){
			//whole numbers have no empty spaces.. hence can't be random
			//zero has only empty spaces and hence can't be random
			//halves can only be shaded as first or last
			// no way to make these cases random, so force it to be something else
			this.fillOrder = Math.floor(Math.random()*2) == 0 ? "first":"last";
		}

		if (this.forceFillColour){
			this.fillColour = this.customFillColour;//needs to be reset for subsequent window resizes to work

			//recalculate the partWidthArray so it resizes properly with new dimensions
			for (var r=0; r < this.numRows; r++){
				for(var c=0; c<this.numColumns; c++){
					if (c <(this.numColumnsPerWhole+1)*(this.numFullWholes)){//the full wholes and spaces between wholes
						if(c%(this.numColumnsPerWhole+1)==this.numColumnsPerWhole){//empty space
							this.partWidthArray.push(this.spaceBetweenWholesWidth);
						} else{
							this.partWidthArray.push(this.partitionWidth);
						}
					} else {//the last whole
						this.partWidthArray.push(this.partitionWidth);
					}
				}
			}
			//zog("this.forceFillColour: "+this.forceFillColour+" line:124 file:FractionArray.js");
			//zog("this.fillColourArray: line:125 file:FractionArray.js");zta(this.fillColourArray);
			//zog("this.partWidthArray: line:126 file:FractionArray.js");zta(this.partWidthArray);
		} else {
			this.fillColour = arrayColours[Math.floor(Math.random()*arrayColours.length)];

			var shadedCount = 0;
			var unshadedCount = 0;

			for (var r=0; r < this.numRows; r++){
				for(var c=0; c<this.numColumns; c++){
					if (c <(this.numColumnsPerWhole+1)*(this.numFullWholes)){//fill the full wholes and the empty spaces between wholes
						if(c%(this.numColumnsPerWhole+1)==this.numColumnsPerWhole){//empty space
							this.fillColourArray.push(0);
							this.partWidthArray.push(this.spaceBetweenWholesWidth);
						} else{
							this.fillColourArray.push(this.fillColour);
							this.partWidthArray.push(this.partitionWidth);
						}
					} else {//fill the last partial whole
						if(this.fillOrder == "first"){
							if (shadedCount < numShadedPartsInLastWhole){
								this.fillColourArray.push(this.fillColour);
								shadedCount++;
							} else {
								this.fillColourArray.push("white");
								unshadedCount++;
							}
						}else if (this.fillOrder == "last"){
							if(unshadedCount <numUnShadedParts){
								this.fillColourArray.push("white");
								unshadedCount++;
							} else {
								this.fillColourArray.push(this.fillColour);
								shadedCount++;
							}
						} else {//random
							if((shadedCount < numShadedPartsInLastWhole) && (unshadedCount < numUnShadedParts)){
								if (Math.floor(Math.random()*2) == 1){
									this.fillColourArray.push(this.fillColour);
									shadedCount++;
								} else {
									this.fillColourArray.push("white");
									unshadedCount++;
								}
							} else if (shadedCount == numShadedPartsInLastWhole){
								if(unshadedCount > 0){
									//randomness has been achieved, fill in the rest with white
									this.fillColourArray.push("white");
									unshadedCount++;
								} else {
									//asked for a random fill, but got fillOrder = first, abort
									success = false;
									break;
								}
							} else if (unshadedCount == numUnShadedParts){
								if (shadedCount > 0){
									//randomness has been achieved, fill in the rest with colour
									this.fillColourArray.push(this.fillColour);
									shadedCount++;
								} else {
									//asked for a random array but got fillorder = last, abort
									success = false;
									break;
								}
							} else{
								zog("WARNING - something went wrong with the shading")
							}
						}
						this.partWidthArray.push(this.partitionWidth);
					}
				}
			}
		}
		if (success){
			//build the array
			for (var r=0; r < this.numRows; r++){
				var xPos = this.horMargin;
				for(var c=0; c<this.numColumns; c++){
					myPart = new Rectangle({width:this.partWidthArray[this.partsArray.length], height:this.partitionHeight, color: this.fillColourArray[this.partsArray.length], borderColor:"gray", borderWidth:0, dashed:true});
					myPart.x = xPos;
					if(c <(this.numColumnsPerWhole+1)*(this.numFullWholes)){
						if(c%(this.numColumnsPerWhole+1)==this.numColumnsPerWhole){
							xPos +=this.spaceBetweenWholesWidth;
						} else {
							xPos +=this.partitionWidth;
						}
					} else{
						xPos +=this.partitionWidth;
					}
					myPart.addTo(this.contentContainer);
					myPart.y = r*this.partitionHeight +this.vertMargin;
					this.partsArray.push(myPart);
				}
			}
		} else {
			if (this.loopCounter >20){
				zog("Too many attempts.. bailing!!! Bet you see some black cells!line:199 file:FractionArray.js");
			} else {
				//random build failed, try again
				this.fillColourArray = new Array();
				this.partWidthArray = new Array();
				this.createArray();
			}
		}

	}

	createPartitions(){
		var wholeWidth = this.numColumnsPerWhole*this.partitionWidth;
		var numDashes;
		if(this.numWholes == 1){
			numDashes = 6;
		} else if (this.numWholes == 2){
			numDashes = 4;
		} else if ( this.numWholes == 3){
			numDashes = 3;
		}

		var horDashLength = Math.round(0.6*wholeWidth/numDashes);//allocate 60 percent of the whole width for dashes
		var wholeHeight = this.partitionHeight*this.numRows;
		var vertDashLength = Math.round(0.6*wholeHeight/numDashes);//allocate 60 percent of the whole Height for dashes
		var dashLength = Math.min(horDashLength,vertDashLength);
		var spaceLength = (wholeWidth - numDashes*dashLength)/(numDashes - 1);

		this.grid = new Shape().addTo(this.contentContainer);
		this.grid.graphics.ss(this.dashWeight,"square").s("gray").sd([dashLength, spaceLength], 0);//sd = setStrokeDash

		//draw vertical lines
		for(var i = 0; i < this.numColumns - 1; i++){
			this.grid.graphics.mt(this.partsArray[i].x + this.partsArray[i].width , this.partsArray[i].y)
			this.grid.graphics.lt(this.partsArray[i].x + this.partsArray[i].width , this.partsArray[i].y + this.partsArray[i].height * this.numRows);
		}

		//draw horizontal lines
		for(var i = 0; i < this.numRows - 1; i++){
			for (var w = 0; w < this.numWholes; w ++){
				this.grid.graphics.mt(this.partsArray[w*(this.numColumnsPerWhole + 1)].x, this.partsArray[i*this.numColumns].y + this.partsArray[i*this.numColumns].height);
				this.grid.graphics.lt(this.partsArray[w*(this.numColumnsPerWhole + 1)].x + this.partsArray[w*(this.numColumnsPerWhole +1)].width * this.numColumnsPerWhole, this.partsArray[i*this.numColumns].y + this.partsArray[i*this.numColumns].height);
			}
		}
	}

	createWholeBorders(){
		//create empty rectangles to act as the wholes
		if(this.fractionValue >1){
			for (var i=0; i < this.numWholes; i ++){
				var wholeWidth = this.numColumnsPerWhole*this.partitionWidth;
				var wholeHeight = this.partitionHeight * this.numRows;
				this.wholeBorder = new Rectangle({width:wholeWidth, height:wholeHeight, color:0, borderColor:"black", borderWidth:this.borderWeight});
				this.wholeBorder.addTo(this.contentContainer);
				this.wholeBorder.x = this.horMargin + i*(this.numColumnsPerWhole*this.partitionWidth + this.spaceBetweenWholesWidth);
				this.wholeBorder.y = this.vertMargin;
			}
		} else{
			this.wholeBorder = new Rectangle({width:this.availableWidth, height:this.availableHeight, color:0, borderColor:"black", borderWidth:this.borderWeight});
			this.wholeBorder.addTo(this.contentContainer);
			this.wholeBorder.x = this.horMargin;
			this.wholeBorder.y = this.vertMargin;
		}
	}

	zogString(){
		return "FractionArray "+this.whole+"  "+this.numerator+"/"+this.denominator;
	}
}