class FractionNumberLine extends FractionRepresentation { // use JS6 extends keyword
	constructor (whole, numerator, denominator, drawWidth, drawHeight, customParms) {
		super(whole, numerator, denominator, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		if (customParms && customParms.usePoint){
			this.usePoint = customParms.usePoint;
		} else {
			this.usePoint = false;
		}
		//zog("Creating a FractionNumberLine - numerator="+this.numerator+" denominator="+this.denominator+" usePoint "+ this.usePoint);

		//the main line
		var roundedWidth = Math.floor(this.drawWidth);
		var roundedHeight = Math.floor(this.drawHeight*0.035); //Math.floor(Math.max(this.drawHeight*0.025, stageHeight*0.006));
		var majorTickArray = [];
		var line = new Shape().addTo(this.contentContainer); // width, height
		line.graphics.ss(roundedHeight).s(white).mt(0, this.drawHeight/2).lt(roundedWidth, this.drawHeight/2);

		//draw the minor ticks
		var halfMinorTickHeight = Math.max(Math.round(roundedHeight*1.5), 5);
		//var minorTickWeight = 1; //Math.round(roundedHeight*0.67);
		var maxTick = Math.ceil(this.decimalValueOf());
		var numberOfMinorTicks = maxTick*this.denominator;
		var minorTickWeight= Math.max(1, Math.ceil(roundedHeight/4));
		//zog("minorTickWeight: "+minorTickWeight+" line:24 file:FractionNumberLine.js");
		minorTickWeight = Math.round(Math.max(minorTickWeight, roundedWidth/(36*3)));
		//zog("minorTickWeight: "+minorTickWeight+" line:26 file:FractionNumberLine.js");
		for(var k=1;k<maxTick*this.denominator;k++){
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = k/maxTick/this.denominator*roundedWidth;
			tick.graphics.ss(minorTickWeight).s(light).mt(xPos, this.drawHeight/2 + halfMinorTickHeight).lt(xPos, this.drawHeight/2 - halfMinorTickHeight);
		}

		//draw the major ticks (should go over the minor ticks and cover them up)
		var halfMajorTickHeight = Math.max(Math.round(roundedHeight*2.5), 8);
		var maxTick = Math.max(1, Math.ceil(this.decimalValueOf()));
		for(var j=0;j<maxTick + 1;j++){
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = j/maxTick*roundedWidth;
			tick.graphics.ss(roundedHeight).s(white).mt(xPos, this.drawHeight/2 + halfMajorTickHeight).lt(xPos, this.drawHeight/2 - halfMajorTickHeight);
			majorTickArray.push(tick);
		}

		//draw the point
		var lineColour = '#ff4046';//'#ff2433'; //'#e89694'; //a lighter red
		if (this.usePoint || this.decimalValueOf() == 0){
			var radius = Math.floor(Math.max(roundedHeight*1.5, 3));
			var posPoint = new Circle(radius, lineColour).addTo(this.contentContainer);
			posPoint.x = this.decimalValueOf()/maxTick*roundedWidth;
			posPoint.y = this.drawHeight/2;
		} else {
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = k/maxTick/this.denominator*roundedWidth;
			var redLineWeight = Math.floor(roundedHeight*2);
			tick.graphics.ss(redLineWeight).s(lineColour).mt(0, this.drawHeight/2 -2*roundedHeight).lt(this.decimalValueOf()/maxTick*roundedWidth, this.drawHeight/2 -2*roundedHeight);
		}

		//the zero and one label
		var labelHeight = Math.min(Math.round(roundedHeight*6), cardHeight/5);
		var labelArray = [];
		for(var j=0;j<2;j++){
			var tickLabel = new Label({
				text:j,
				size:labelHeight,
				font:fontFace,
				color:white,
				fontOptions:"bold"
			});
			tickLabel.addTo(this.contentContainer);
			labelArray.push(tickLabel);
		}
		//labelArray[0].y = this.drawHeight/2 +3*roundedHeight;
		var aMajorTick = majorTickArray[0];
		labelArray[0].y = Math.ceil(this.drawHeight/2 + halfMajorTickHeight*1.25);
		labelArray[1].y = labelArray[0].y;
		labelArray[0].x = -labelArray[0].width/2;
		labelArray[1].x = 1/maxTick*roundedWidth - labelArray[1].width/2;

		return this; //for chaining
	}

	zogString(){
		return "FractionNumberLine "+this.whole+"  "+this.numerator+"/"+this.denominator+" ("+this.usePoint+")";
	}
}