
//This class will show a numeric representation of a fraction.
class FractionNumeric extends FractionRepresentation { // use JS6 extends keyword
	constructor (whole, numerator, denominator, drawWidth, drawHeight, customParms) {
		super(whole, numerator, denominator, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor

		if (customParms && customParms.displayAsMixed != null){
			this.displayAsMixed = customParms.displayAsMixed;
		} else {
			this.displayAsMixed = false;
		}

		if (customParms && customParms.labelColour){
			this.labelColour = customParms.labelColour;
		} else {
			this.labelColour = "white";
		}

		var decimalValue = this.decimalValueOf();
		if (this.displayAsMixed){
			this.whole = Math.floor(decimalValue);
			this.numerator = Math.round((decimalValue - this.whole)*this.denominator);
		} else {
			this.numerator = Math.round(decimalValue*this.denominator);
			this.whole = 0;
		}

		this.fractionContainer = new Container();

		//zog("Creating a "+this.zogString());

		//The label showing the numerator
		this.numeratorLabel = new Label({
			text:this.numerator,
			size:Math.min(this.drawWidth,this.drawHeight)*0.4,
			font:"arial",
			color:this.labelColour,
			fontOptions:"bold"
		});

		//The label showing the denominator
		this.denominatorLabel = new Label({
			text:this.denominator,
			size:Math.min(this.drawWidth,this.drawHeight)*0.4,
			font:"arial",
			color:this.labelColour,
			fontOptions:"bold"
		});

		//The label showing the wholeLabel
		this.wholeLabel = new Label({
			text:this.whole,
			size:Math.min(this.drawWidth,this.drawHeight)*0.8,
			font:"arial",
			color:this.labelColour,
			fontOptions:"bold"
		});

		//This is the line that separates the numerator and denominator. Geeky name for it
		this.vinculum = new Rectangle({width:Math.min(this.drawWidth,this.drawHeight)*0.4, height:3, color:this.labelColour});

		this.showFraction = false;
		this.showWhole = false;
		//Let us add them all to our rectangle placeholder
		if (!this.displayAsMixed || this.numerator != 0){
			this.vinculum.addTo(this.fractionContainer);
			this.numeratorLabel.addTo(this.fractionContainer);
			this.denominatorLabel.addTo(this.fractionContainer);
			this.showFraction = true;
		}
		if (this.displayAsMixed && (this.whole != 0 || decimalValue == 0)){
			this.wholeLabel.addTo(this.fractionContainer);
			this.showWhole = true;
		}
		this.fractionContainer.addTo(this.contentContainer);
		this.positionLabels();

		return this;
	}

	//If you want to re-position the labels, call this function
	positionLabels(){
		//We are going to start assuming that the whole is hidden
		if (this.showFraction){
			this.numeratorLabel.x = (this.drawWidth - this.numeratorLabel.width)/2;
			this.denominatorLabel.x = (this.drawWidth - this.denominatorLabel.width)/2;
			this.vinculum.x = (this.drawWidth - this.vinculum.width)/2;

			//Place things in the center
			this.margin = 5;
			this.totalHeight = this.numeratorLabel.height + this.denominatorLabel.height + this.vinculum.height + 2*this.margin;
			this.numeratorLabel.y = 0;
			this.vinculum.y = this.numeratorLabel.y + this.numeratorLabel.height + this.margin;
			this.denominatorLabel.y = this.vinculum.y+this.vinculum.height + this.margin;

			//The whole is not hidden, time to adjust positioning
			if (this.showWhole){
				var totalWidth = this.wholeLabel.width + this.vinculum.width;
				var xDiff = this.numeratorLabel.x - this.vinculum.x;
				this.wholeLabel.x = (this.drawWidth - totalWidth)/2;
				this.numeratorLabel.x = this.wholeLabel.x + this.wholeLabel.width + xDiff;
				this.vinculum.x = this.wholeLabel.x + this.wholeLabel.width;
				this.denominatorLabel.x = this.vinculum.x + (this.vinculum.width - this.denominatorLabel.width)/2;
				this.wholeLabel.y = this.numeratorLabel.y + (this.totalHeight - this.wholeLabel.height)/2;
			}
		} else if (this.showWhole){
			this.wholeLabel.center(this.fractionContainer);
		}
		this.fractionContainer.center(this.contentContainer);

		return this; //for chaining
	}

	zogString(){
		return "FractionNumeric "+this.whole+"  "+this.numerator+"/"+this.denominator+" ("+this.displayAsMixed+")";
	}
}