class FractionRepresentation extends Container { // use JS6 extends keyword

	//This constructor expects
	constructor (whole, numerator, denominator, drawWidth, drawHeight, customParms) {
		//handle whole as an array of parameters
		//code from https://idiallo.com/blog/javascript-how-do-i-check-if-this-variable-is-an-array
		var s = typeof whole;
		if (s === 'object') {
			if (whole) {
				if (whole instanceof Array) {
					numerator = whole[1];
					denominator = whole[2];
					drawWidth = whole[3];
					drawHeight = whole[4];
					customParms = whole[5];
					whole = whole[0];
				}
			}
		}
		super(); // use JS6 super() to call the Container constructor
		this.defaultSize = 200; //in case dimensions are not passed in

		if (whole==null){
			this.whole = 0;
		} else {
			this.whole = whole;
		}

		if (numerator == null){
			this.numerator = 0;
		} else {
			this.numerator = numerator;
		}

		if (denominator==null){
			this.denominator = 1;
		} else {
			this.denominator = denominator;

			if(denominator==0){
				zog("WARNING - do not use a denominator of zero unless you want the universe to implode. Line 23:FractionRepresentation.js")
				this.denominator = 1;
			}
		}

		if (drawWidth==null){
			this.drawWidth = this.defaultSize;
		} else {
			this.drawWidth = drawWidth;
		}

		if (drawHeight==null){
			this.drawHeight = this.defaultSize;
		} else {
			this.drawHeight = drawHeight;
		}

		this.customParms = customParms;

		//This is the container that is going to hold all our content.
		//change borderWidth to something bigger than 0.1 to see all contentContainers
		this.contentContainer = new Rectangle({width:this.drawWidth, height:this.drawHeight, color:"rgba(0,0,0,0)"/*, borderColor:"rgba(0,0,0,0)", borderWidth:0.01*/});
		this.contentContainer.addTo(this);
	}

	//This function will take as input a whole, numerator and denominator and return true if it is equivalent to this instance's value
	equivalentTo(givenWhole, givenNumerator, givenDenominator){
		if(givenDenominator==0){
			zog("WARNING - can't pass a denominator of zero! - line 16:FractionRepresentation.js")
			return false;
		}
		return Math.abs((this.whole+this.numerator/this.denominator) - (givenWhole+givenNumerator/givenDenominator))<0.0001;
	}

	decimalValueOf(){
		return (this.whole+this.numerator/this.denominator);
	}

	zogString(){
		return "FractionRepresentation "+this.whole+"  "+this.numerator+"/"+this.denominator;
	}
}