class FractionStrip extends FractionRepresentation { // use JS6 extends keyword

	constructor (whole, numerator, denominator, drawWidth, drawHeight, customParms) {
		super(whole, numerator, denominator, drawWidth, drawHeight, customParms); // use JS6 super() to call the Container constructor
		//zog("Creating a FractionStrip - numerator="+this.numerator+" denominator="+this.denominator);
		var currentColour;
		var minorColour = light; //"#333333"
		var majorColour = light;//"#CCCCCC"; //black
		if (customParms && customParms.stripColour != null){
			currentColour = customParms.stripColour;
		} else {
			currentColour = "#888888";
		}

		var fractionValue = this.decimalValueOf();
		var maxTick = Math.ceil(fractionValue);
		var roundedWidth = Math.floor(this.drawWidth);
		var roundedHeight = Math.floor(this.drawHeight*0.25);

		//shade for the strip
		var fillRect = new Rectangle(fractionValue/maxTick*roundedWidth, roundedHeight, currentColour, "rgba(0,0,0,0)", 1).addTo(this.contentContainer);
		var middleY = this.drawHeight/2 - roundedHeight/2;
		fillRect.y = middleY;

		//the big rectangle
		var borderWeight = Math.floor(roundedHeight/10);
		var wholeBorder = new Rectangle(roundedWidth, roundedHeight, "rgba(0,0,0,0)", majorColour, borderWeight).addTo(this.contentContainer);
		wholeBorder.y = middleY;

		//draw the minor ticks

		var maxTickForMinors = Math.max(1, maxTick);
		var numberOfMinorTicks = maxTickForMinors*this.denominator;
		var minorTickWeight= Math.max(1, Math.ceil(borderWeight/4));
		//zog("minorTickWeight: "+minorTickWeight+" line:35 file:FractionStrip.js");
		minorTickWeight = Math.round(Math.max(minorTickWeight, roundedWidth/(36*3)));
		//zog("minorTickWeight: "+minorTickWeight+" line:37 file:FractionStrip.js");
		for(var k=1;k<numberOfMinorTicks;k++){ //fractionValue*this.denominator + 1
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = k/maxTickForMinors/this.denominator*roundedWidth;
			tick.graphics.ss(minorTickWeight).s(minorColour).mt(xPos, middleY + borderWeight/2).lt(xPos, middleY + roundedHeight - borderWeight/2);
		}

		//draw the major ticks (should go over the minor ticks and cover them up)
		var majorTickArray = [];

		var halfMajorTickHeight = Math.round(roundedHeight*2.5);
		for(var j=1;j<maxTick + 1;j++){
			var tick = new Shape().addTo(this.contentContainer);
			var xPos = j/maxTick*roundedWidth;
			var wholeTickHeightMultiplier = zim.mobile?4:2;
			tick.graphics.ss(borderWeight).s(majorColour).mt(xPos, middleY - wholeTickHeightMultiplier*borderWeight).lt(xPos, middleY + roundedHeight - borderWeight/2);
			majorTickArray.push(tick);
		}
		return this; //for chaining
	}

	zogString(){
		return "FractionStrip "+this.whole+"  "+this.numerator+"/"+this.denominator;
	}
}