
//This class will show a numeric representation of a fraction.
class LevelIndicator extends Container { // use JS6 extends keyword
	constructor (labelSize, labelColour, fontOptions) {
		super(); // use JS6 super() to call the Container constructor
		this.name = "LevelIndicator";
		if (labelSize == null){
			this.labelSize = 40;
		} else {
			this.labelSize = labelSize;
		}
		if (labelColour == null){
			this.labelColour = white;
		} else {
			this.labelColour = labelColour;
		}
		if (fontOptions == null){
			this.fontOptions = "";
		} else {
			this.fontOptions = fontOptions;
		}
		this.position();

		//To allow chaining
		return this;
	}

	position(){
		var margin = getMargin();
		this.buttonSize = Math.floor(menuHeight*0.85);

		//the background of the LevelIndicator
		if (this.contentContainer){
			this.contentContainer.parent.removeChild(this.contentContainer);
		}

		//size and position the levelLabel
		if (!this.levelLabel){
			this.levelLabel = new Label({
				text:localization.level[localizationIndex] + " " + localization.levelDescriptions[localizationIndex][currentLevel],
				size:this.labelSize,
				font:fontFace,
				color:this.labelColour,
				fontOptions:this.fontOptions
			});
		} else {
			this.levelLabel.text = localization.level[localizationIndex] +" " + localization.levelDescriptions[localizationIndex][currentLevel];
			this.levelLabel.size = this.labelSize;
		}
		this.levelLabel.addTo(this);

		//the stars
		var currX = this.levelLabel.width + this.labelSize;
		var openingStar = openingDialog.stars[0]
		for (var i=0; i < numberOfStars[currentLevel];i++){
			var star = new Star(this.labelSize/2, openingStar.starColour, openingStar.starOutlineColour, 1, false)
				.addTo(this)
				.loc(currX, this.levelLabel.height - this.labelSize/2);
			currX += 1.25*this.labelSize;
		}
	}
}