/*Generate an array of cards to draw with their matches

Level 	0	[0,1] with denominators 2, 3, 4, 6, 8
		1	[0, 1] with denominators 1 - 12
		2	[0,5] with denominators 2, 3, 4, 6, 8
		3	[0, 5] with denominators 1 - 12 (proper, improper, mixed)

*/

var nextDisplayAsMixed = true;
var fillOrders = ["first", "last", "random"];
var nextFillOrder = 0;

var stripColoursBucket = [];
var nextUsePoint = false;
var chosenWholes;
var chosenNumerators;
var chosenDenominators;

function generateQuestions(){
	//for testing - openingDialog to set
	//representationArray = [FractionNumeric, FractionArray, FractionNumberLine, FractionStrip];
	//zog("representationArray.length: "+representationArray.length+" line:23 file:questionGenerator.js");

	var numberOfPairs;
	var denominatorArray;

	var allowMixed = false;
	numberOfPairs = Math.floor(getNumberOfCards()/2);
	//zog("currentLevel: "+currentLevel+" line:30 file:questionGenerator.js");
	if (currentLevel == 0){
		denominatorArray = [2, 3, 4, 6, 8];
	} else if (currentLevel == 1){
		denominatorArray = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
	} else if (currentLevel == 2){
		denominatorArray = [2, 3, 4, 6, 8];
		allowMixed = true;
	} else {
		denominatorArray = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
		allowMixed = true;
	}
	var possibleWholes = [0, 1, 2];

	var maxNumberOfWholes = 1;
	var numberOfWholes = 0;

	var chosenWholes = [];
	var chosenNumerators = [];
	var chosenDenominators = [];

	var possibleGameValues = gameFractions2[currentLevel%2];
	var fractionsBucket = copyGames(possibleGameValues);
	var tempFractionsBucket = copyGames(possibleGameValues);

	var currentChoice;
	var currentValue;
	var currentDenominator;
	var safetyCounter = 0;
	while (chosenDenominators.length < numberOfPairs && safetyCounter < possibleGameValues.length*2){
		//choose a fraction
		var randomIndex = Math.floor(Math.random()*tempFractionsBucket.length);
		currentChoice = tempFractionsBucket[randomIndex];
		currentValue = currentChoice.value;
		currentDenominator = currentChoice.denominator;
		chosenDenominators.push(currentDenominator);
		chosenNumerators.push(currentChoice.numerator);
		if (allowMixed){
			chosenWholes.push(choose(possibleWholes, 1)[0]);
		} else {
			chosenWholes.push(0);
		}

		//take the fraction out of the basket
		tempFractionsBucket.splice(randomIndex, 1)[0];

		//zog("Taking: "+currentChoice.numerator+"/"+currentChoice.denominator+" line:76 file:questionGenerator.js "+currentChoice.value);
		//take all the equivalent ones out for good
		for (var s=fractionsBucket.length - 1; s>-1; s--){
			if (fractionsBucket[s].value == currentValue){
				var spliced = fractionsBucket.splice(s, 1)[0]
				//zog("\tsplicing "+spliced.numerator+"/"+spliced.denominator+" line:81 file:questionGenerator.js");
			}
		}
		//take all the equivalent ones out of the temporary basket
		for (var s=tempFractionsBucket.length - 1; s>-1; s--){
			if (tempFractionsBucket[s].value == currentValue){
				var spliced = tempFractionsBucket.splice(s, 1)[0]
				//zog("\tsplicing "+spliced.numerator+"/"+spliced.denominator+" line:88 file:questionGenerator.js");
			}
		}
		//take all the fractions with the same denominator out of the temporary basket
		for (var s=tempFractionsBucket.length - 1; s>-1; s--){
			if (tempFractionsBucket[s].denominator == currentDenominator){
				var spliced = tempFractionsBucket.splice(s, 1)[0]
				//zog("\tsplicing "+spliced.numerator+"/"+spliced.denominator+" line:95 file:questionGenerator.js");
			}
		}
		if (Math.floor(currentValue) == currentValue){
			numberOfWholes++;
		}
		if (numberOfWholes == maxNumberOfWholes){
			//if there are the right number of wholes, get rid of the rest
			for (var s=fractionsBucket.length - 1; s>-1; s--){
				if (Math.floor(fractionsBucket[s].value) == fractionsBucket[s].value){
					var spliced = fractionsBucket.splice(s, 1)[0]
					//zog("\tsplicing "+spliced.numerator+"/"+spliced.denominator+" line:106 file:questionGenerator.js");
				}
			}
			for (var s=tempFractionsBucket.length - 1; s>-1; s--){
				if (Math.floor(tempFractionsBucket[s].value) == tempFractionsBucket[s].value){
					var spliced = tempFractionsBucket.splice(s, 1)[0]
					//zog("\tsplicing "+spliced.numerator+"/"+spliced.denominator+" line:112 file:questionGenerator.js");
				}
			}
		}
		if (tempFractionsBucket.length == 0){
			//zog("Nothing left to choose from line:117 file:questionGenerator.js");
			tempFractionsBucket = copyGames(fractionsBucket);
		}
		if (fractionsBucket.length == 0){
			zog("Unexpected error with fractions line:121 file:questionGenerator.js");
			break;
		}
		safetyCounter++;
	}
	//zog("safetyCounter: "+safetyCounter+" line:126 file:questionGenerator.js");

	//zog("chosenWholes: "+chosenWholes+" line:128 file:questionGenerator.js");
	//zog("chosenNumerators: "+chosenNumerators+" line:129 file:questionGenerator.js");
	//zog("chosenDenominators: "+chosenDenominators+" line:130 file:questionGenerator.js");

	//this is where you can hack the question generation to ensure certain values
	/*chosenWholes[0] = 1;
	chosenNumerators[0] = 1;
	chosenDenominators[0] = 1;

	chosenWholes[1] = 1;
	chosenNumerators[1] = 1;
	chosenDenominators[1] = 2;

	chosenWholes[2] = 1;
	chosenNumerators[2] = 2;
	chosenDenominators[2] = 3;

	chosenWholes[3] = 2;
	chosenNumerators[3] = 2;
	chosenDenominators[3] = 4;

	chosenWholes[4] = 1;
	chosenNumerators[4] = 4;
	chosenDenominators[4] = 5;

	chosenWholes[5] = 1;
	chosenNumerators[5] = 5;
	chosenDenominators[5] = 6;

	chosenWholes[6] = 1;
	chosenNumerators[6] = 5;
	chosenDenominators[6] = 7;

	chosenWholes[7] = 2;
	chosenNumerators[7] = 7;
	chosenDenominators[7] = 8;

	chosenWholes[8] = 1;
	chosenNumerators[8] = 8;
	chosenDenominators[8] = 9;

	chosenWholes[9] = 1;
	chosenNumerators[9] = 5;
	chosenDenominators[9] = 10;

	chosenWholes[10] = 1;
	chosenNumerators[10] = 5;
	chosenDenominators[10] = 11;

	chosenWholes[11] = 2;
	chosenNumerators[11] = 7;
	chosenDenominators[11] = 12;*/

	//choose the representations
	var representationPairings = [];
	var numberOfRepresentations = representationArray.length;
	for (var i=0;i<numberOfRepresentations;i++) {
		for (var j=i+1;j<numberOfRepresentations;j++) {
			representationPairings.push([representationArray[i], representationArray[j]]);
		}
	}
	var chosenRepresentationPairings = choose(representationPairings, numberOfPairs);

	//setup the questionArray
	var traceString = "";
	questionArray = [];
	for (var i=0;i<numberOfPairs;i++) {
		questionArray.push(addQuestion(chosenRepresentationPairings[i][0], chosenWholes[i], chosenNumerators[i], chosenDenominators[i], allowMixed));
		questionArray.push(addQuestion(chosenRepresentationPairings[i][1], chosenWholes[i], chosenNumerators[i], chosenDenominators[i], allowMixed));
		traceString += chosenWholes[i]+"  "+chosenNumerators[i]+"/"+chosenDenominators[i]+ " -- ";
	}
	//zog(traceString);
}

function addQuestion(repClass, whole, numerator, denominator, allowMixed){
	var customParms;
	var randomIndex;
	if (repClass == FractionNumeric){
		if (allowMixed && (whole+numerator/denominator) >= 1){
			customParms = {displayAsMixed:nextDisplayAsMixed};
			nextDisplayAsMixed = !nextDisplayAsMixed;
		} else {
			customParms = {displayAsMixed:false};
		}
	} else if (repClass == FractionArray){
		customParms = {fillOrder:fillOrders[nextFillOrder%3]};
		nextFillOrder++
	} else if (repClass == FractionNumberLine){
		customParms = {usePoint:nextUsePoint};
		nextUsePoint = !nextUsePoint;
	} else if (repClass == FractionStrip && (whole+numerator/denominator) > 0){
		if (stripColoursBucket.length == 0){
			stripColoursBucket = copyArray(stripColours);
		}
		var randomIndex = Math.floor(Math.random()*stripColoursBucket.length);
		customParms = {stripColour:stripColoursBucket.splice(randomIndex, 1)[0]};
	}
	//zog(whole+"  "+numerator+"/"+denominator);
	return {
				representation:
					{
						repClass:repClass,
						whole:whole,
						numerator:numerator,
						denominator:denominator,
						customParms:customParms
					},
				sortOrder:Math.random()
			};
}