//This set of code relates to the information dialog

function createInfoButton(){

    if(loadedLocally){
      informationButton = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("infoButtonBlueSmallid")))
    } else {
      informationButton = PIXI.Sprite.fromImage('assets/infoButtonBlueSmall.png');
    }

  // center the sprite anchor point
  informationButton.anchor.set(0.5, 0.5);
  informationButton.visible = true;
  informationButton.width = singleCardDimensions;
  informationButton.height = singleCardDimensions;
  gameScene.addChild(informationButton);

  informationButton.x = dropDownButton.x + 13.7*singleCardDimensions;
  informationButton.y = 0.25*margin;

  informationButton.interactive = true;
  informationButton.buttonMode = true;

  informationButton.on('pointerdown', showInfoDialog);

  console.log("informationButton = "+informationButton+" line 21")

}


//This creates the information dialog complete with grey background, close button and the rest
function createInfoDialog(){
    //This is the first time the button has been pressed, so let's create our info dialog
    infoDialog = new PIXI.Graphics();

    // The infoDialog itself will have a grey background which dismisses the dialog upon click
    infoDialog.greyBackground = new PIXI.Graphics();
    infoDialog.greyBackground.beginFill(0xcccccc, 0.5);
    infoDialog.greyBackground.lineStyle(3, 0xcccccc, 1);
    infoDialog.greyBackground.drawRect(0, 0, WORKSPACE_WIDTH, WORKSPACE_HEIGHT);
    infoDialog.addChild(infoDialog.greyBackground);

    //arbitrary decision to make the dialog 2/3 of the width of the workspace
    var widthPercent = localizationIndex==0?0.66:0.75;
    var dialogDrawWidth = WORKSPACE_WIDTH*widthPercent;

    //Now we will create the actual rectangle with the information we need
    infoDialog.dialogWindow = new PIXI.Graphics();
    infoDialog.dialogWindow.beginFill(0xFFFFFF, 1);
    infoDialog.dialogWindow.lineStyle(4, 0, 1);
    //infoDialog.dialogWindow.drawRect(0, 0, dialogDrawWidth, WORKSPACE_HEIGHT/2);
    infoDialog.dialogWindow.x = 0.5*(WORKSPACE_WIDTH - dialogDrawWidth);
    infoDialog.dialogWindow.y = 0.5*(WORKSPACE_HEIGHT - infoDialog.dialogWindow.height);
    infoDialog.dialogWindow.interactive = true;
    infoDialog.dialogWindow.buttonMode = true;

    infoDialog.addChild(infoDialog.dialogWindow);

    //Let's create the title text first so we know it's height
    infoDialog.titleBarText = new PIXI.Text(
    localization.information[localizationIndex],
    {fontFamily :'Arial',  fontSize: singleCardDimensions*0.4, fill: "white", align : 'center', stroke: '#000000', strokeThickness: 1}
    );

    //No we will create the Title Bar rectangle and then put the text and close rectangle on it
    infoDialog.titleBar = new PIXI.Graphics();
    infoDialog.titleBar.beginFill(clipsBlue, 1);
    infoDialog.titleBar.lineStyle(1, 0, 1);
    infoDialog.titleBar.drawRect(0, 0, dialogDrawWidth-3, infoDialog.titleBarText.height*1.2);
    infoDialog.dialogWindow.addChild(infoDialog.titleBar);
    infoDialog.titleBar.x=1;

    //Let's create the tool name first so we know it's height
    infoDialog.titleBarToolName = new PIXI.Text(
    localization.infoDialogTitle[localizationIndex],
    {fontFamily :'Arial',  fontSize: singleCardDimensions*0.4, fill: "white", align : 'center', stroke: '#000000', strokeThickness: 1}
    );

    //Let's create the x in the upper right corner of the dialog
    infoDialog.closeRectangle = createCloseButton(0.4, 0, 2);
    infoDialog.closeRectangle.on('pointerdown', hideInfoDialog);

    var titleBarMargin = infoDialog.titleBarText.height*0.1;
    infoDialog.titleBarText.x = titleBarMargin;
    infoDialog.titleBarText.y = titleBarMargin;
    infoDialog.titleBar.addChild(infoDialog.titleBarText);

    infoDialog.titleBarToolName.x = 0.5*(infoDialog.titleBar.width - infoDialog.titleBarToolName.width);
    infoDialog.titleBarToolName.y = titleBarMargin;
    infoDialog.titleBar.addChild(infoDialog.titleBarToolName);

    infoDialog.closeRectangle.y = 0.5*(infoDialog.titleBar.height - infoDialog.closeRectangle.height)
    infoDialog.closeRectangle.x = infoDialog.titleBar.width - infoDialog.closeRectangle.width - infoDialog.closeRectangle.y;

    infoDialog.titleBar.addChild(infoDialog.closeRectangle);
    //End of title bar code

    var spacer = infoDialog.titleBar.height/2;

    //The first line in the dialog under the title bar
    infoDialog.introText = new PIXI.Text(
    localization.infoDialogIntro[localizationIndex],
    {fontFamily :'Arial',  fontSize: singleCardDimensions*0.4, fill: "black", align : 'center', stroke: '#FFFFFF', strokeThickness: 0}
    );

    infoDialog.introText.x = 0.5*(dialogDrawWidth - infoDialog.introText.width);
    infoDialog.introText.y = infoDialog.titleBar.height + spacer/2;
    infoDialog.dialogWindow.addChild(infoDialog.introText);

    //Support page button
    //PLEASE NOTE - you can't call supportButton.width or height right after using this method because at runtime the asset needs to load before it knows its width and height. This means that we should be using sprite sheets or just storing the dimensions of the assets somewhere
    if(loadedLocally){
      supportButton = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("supportButtonid")))
      supportButtonFR = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("supportButtonFRid")))
    } else {
      supportButton = PIXI.Sprite.fromImage('assets/supportButton.png');
      supportButtonFR = PIXI.Sprite.fromImage('assets/supportButtonFR.png');
    }
    supportButtonFR.visible = localizationIndex==1;
    supportButton.anchor.set(0.5, 0.5);
    supportButtonFR.anchor.set(0.5,0.5);

    supportButton.x = 0.5*(dialogDrawWidth);
    supportButton.y = infoDialog.introText.y + infoDialog.introText.height + infoButtonHeights/2 + spacer;
    infoDialog.dialogWindow.addChild(supportButton);
    supportButton.interactive = true;
    supportButton.buttonMode = true;
    supportButton.frenchSkin = supportButtonFR;
    supportButton.addChild(supportButtonFR)
    supportButton.mouseup = supportButton.touchend = function(){
      var win=window.open(localization.supportPageLink[localizationIndex], '_blank');
    }

    //Feedback button
    if(loadedLocally){
      feedbackButton = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("feedbackButtonid")))
      feedbackButtonFR = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("feedbackButtonFRid")))
    } else {
      feedbackButton = PIXI.Sprite.fromImage('assets/feedbackButton.png');
      feedbackButtonFR = PIXI.Sprite.fromImage('assets/feedbackButtonFR.png');
    }
    feedbackButtonFR.visible = localizationIndex==1;
    feedbackButton.anchor.set(0.5, 0.5);
    feedbackButtonFR.anchor.set(0.5,0.5);

    feedbackButton.x = 0.5*(dialogDrawWidth);
    feedbackButton.y = supportButton.y + infoButtonHeights + spacer;
    infoDialog.dialogWindow.addChild(feedbackButton);
    feedbackButton.interactive = true;
    feedbackButton.buttonMode = true;
    feedbackButton.frenchSkin = feedbackButtonFR;
    feedbackButton.addChild(feedbackButtonFR)
    feedbackButton.mouseup = feedbackButton.touchend = function(){
        if(localizationIndex==0){
            var win=window.open("http://oame.on.ca/clips/feedback.htm?tool=NumberChart", '_blank');
        } else {
            var win=window.open("http://oame.on.ca/clips/retroaction.htm?tool=NumberChart", '_blank');
        }
    }
    //Let's add the copyright message and place it
    infoDialog.copyrightText = new PIXI.Text(
    localization.copyright[localizationIndex],
    {fontFamily :'Arial',  fontSize: singleCardDimensions*0.4, fill: "black", align : 'left', stroke: '#FFFFFF', strokeThickness: 0}
    );

    infoDialog.copyrightText.x = 0.5*(dialogDrawWidth - infoDialog.copyrightText.width);
    infoDialog.copyrightText.y = feedbackButton.y + infoButtonHeights/2 + spacer;
    infoDialog.dialogWindow.addChild(infoDialog.copyrightText);

    infoDialog.learningToolsText = new PIXI.Text(
    localization.infoDialogMoreAvailable[localizationIndex],
    {fontFamily :'Arial',  fontSize: singleCardDimensions*0.4, fill: "black", align : 'center', stroke: '#FFFFFF', strokeThickness: 0}
    );

    infoDialog.learningToolsText.x = 0.5*(dialogDrawWidth - infoDialog.learningToolsText.width);
    infoDialog.learningToolsText.y = infoDialog.copyrightText.y + infoDialog.copyrightText.height + spacer;
    infoDialog.dialogWindow.addChild(infoDialog.learningToolsText);

    //Learning Tools Page button
    if(loadedLocally){
      learningToolsButton = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("learningToolsButtonid")))
      learningToolsButtonFR = new PIXI.Sprite(PIXI.Texture.fromCanvas(document.getElementById("learningToolsButtonFRid")))
    } else {
      learningToolsButton = PIXI.Sprite.fromImage('assets/learningToolsButton.png');
      learningToolsButtonFR = PIXI.Sprite.fromImage('assets/learningToolsButtonFR.png');
    }
    learningToolsButtonFR.visible = localizationIndex==1;
    learningToolsButton.anchor.set(0.5, 0.5);
    learningToolsButton.calculateBounds();

    learningToolsButton.x = 0.5*(dialogDrawWidth);
    learningToolsButton.y = infoDialog.learningToolsText.y + infoDialog.learningToolsText.height + infoButtonHeights/2 + spacer;

    infoDialog.dialogWindow.addChild(learningToolsButton);

    learningToolsButton.interactive = true;
    learningToolsButton.buttonMode = true;

    learningToolsButtonFR.anchor.set(0.5,0.5);
    learningToolsButton.frenchSkin = learningToolsButtonFR;
    learningToolsButton.addChild(learningToolsButtonFR)
    learningToolsButton.click = learningToolsButton.tap = function(){
        if(localizationIndex==0){
            var win=window.open("https://mathies.ca/learningTools.php", '_blank');
        } else {
            var win=window.open("https://mathies.ca/francais.php", '_blank');
        }
    }

    infoDialog.greyBackground.interactive = true;
    infoDialog.greyBackground.buttonMode = true;
    infoDialog.greyBackground.on('pointerdown', hideInfoDialog);

    infoDialog.dialogWindow.drawRect(0, 0, dialogDrawWidth, learningToolsButton.y+infoButtonHeights/2 + spacer);
    infoDialog.dialogWindow.y = 0.5*(WORKSPACE_HEIGHT - infoDialog.dialogWindow.height);

    gameScene.addChild(infoDialog);
}